IF OBJECT_ID('P_EXP_CTB_MOV_PG_CRED') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EXP_CTB_MOV_PG_CRED
	END
 
GO 
--exec  P_EXP_CTB_MOV_PG_CRED 1,999,'2013-11-01','2013-11-01',1
CREATE PROCEDURE P_EXP_CTB_MOV_PG_CRED(@CD_EMP			INT,
									   @CD_FILIAL		INT,
									   @DT_INI			DATETIME,
									   @DT_FIM			DATETIME,
									   @FLAG_LIMPAR		INT = 0)		
	
  AS 
SET NOCOUNT ON;
BEGIN TRY
BEGIN
	DECLARE @RS_CD_EMP					INT
	DECLARE @RS_CD_FILIAL				INT
	DECLARE @RS_CD_FORN					INT
	DECLARE @RS_HIST					VARCHAR(500)
	DECLARE @RS_CD_CNT					INT
	DECLARE @RS_NR_CHQ					INT
	DECLARE @RS_SERIE_CHQ				VARCHAR(5)
	DECLARE @RS_ANO_CHQ					INT
	DECLARE @RS_CD_PG_DEB_LOTE			INT
	DECLARE @RS_VLR_EMIT_DEST			MONEY
	DECLARE @RS_VL_JUR					MONEY
	DECLARE @RS_VL_DESC					MONEY
	DECLARE @RS_VL_IMP					MONEY
	DECLARE @RS_VLR_DESP_OUTR			MONEY
	DECLARE @RS_VLR_DEVOLUCAO			MONEY
	DECLARE @RS_RZ_FORN					VARCHAR(200)
	DECLARE @RS_NR_TIT					VARCHAR(50)	
	DECLARE @RS_NR_NF					INT 
	DECLARE @RS_DT_PAG					DATETIME
	DECLARE @RS_VLR_CONTA				MONEY
	DECLARE @RS_QTDE_LANC				INT
	DECLARE @RS_CD_BC_LANC				INT
	DECLARE @RS_CD_BC_LANC_ANT			INT
	DECLARE @RET_CD_CTB_CNT				VARCHAR(100)
	DECLARE @RET_CD_CTB_CNT_RED			INT
	DECLARE @RET_DS_CNT					VARCHAR(100)
	DECLARE @RET_NR_CNT_EDI					VARCHAR(50)	
	DECLARE @RET_TITULAR_CNT			VARCHAR(200)
	DECLARE @RET_TP_CNT					INT
	DECLARE @RS_NR_DP					INT
	DECLARE @RS_TIPO_PAGTO              VARCHAR(20)
	DECLARE @RS_CD_BC                   VARCHAR (20) 
	DECLARE @RS_DS_BC                   VARCHAR (30) 
	DECLARE @RS_MOSTRA_DS_CNT INT
	DECLARE @NUM_DUPL                   BIGINT 
	DECLARE @NUMERODUPL                 VARCHAR(20)
	DECLARE @HIST						VARCHAR(200)
	DECLARE @NR_DOCUMENTO               VARCHAR(200) 
	DECLARE @CODIGO_INTERNO				vARCHAR(100)

	SET @RS_CD_BC_LANC_ANT=-1

	------------------------------------------------------------------------------------------------------------------------------
	--CRIANDO A TABELA TEMPORARIA ##CTB_EXP_MOV
	------------------------------------------------------------------------------------------------------------------------------
	EXEC P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV @FLAG_LIMPAR	
	
	--#####################################################################
	--CURSOR EMITENTES DESTINATARIOS
	--#####################################################################	
if object_id ('##RS_RETURN') is not null 
    begin
    drop table ##RS_RETURN 
    end
 CREATE TABLE ##RS_RETURN (
		CD_EMP			INT, 
		CD_CNT			INT,
		CD_FILIAL		INT,
		CD_FORN			INT,
		HIST			VARCHAR(500),
		NR_CHQ			INT,
		SERIE_CHQ		VARCHAR(50),
		ANO_CHQ			INT,
		CD_PG_DEB_LOTE	INT,
		VL_PGTO			MONEY,
		VL_JUR			MONEY,
		VL_DESC			MONEY,
		VL_IMP			MONEY,
		VLR_DESP_OUTR	MONEY,
		VLR_DEVOLUCAO	MONEY,
		RZ_FORN			VARCHAR(200), 
		NR_TIT			VARCHAR(100),
		NM_FANT			VARCHAR(200),
		NR_NF			INT,
		DT_PAG			DATETIME,
		CD_BC_LANC		INT,
		TIPO_PAGTO		VARCHAR(50),
		NR_DP           VARCHAR (50),
		NR_CNT_EDI VARCHAR(100), 
		CD_BC           VARCHAR (10),
		DS_BC           VARCHAR (30),
		MOSTRA_DS_CNT INT,
		DS_CNT VARCHAR(150))

/*
 declare 
 @cd_emp int =1,
 @cd_filial int = 1 ,
 @dt_ini datetime ='2017-01-01',
 @dt_fim datetime = '2017-01-31'
 */
 INSERT INTO ##RS_RETURN 
 EXEC P_UFD_EXP_CTB_MOV_PG_CRED @CD_EMP,@CD_FILIAL,@DT_INI,@DT_FIM 

	DECLARE RS_RESULT
	CURSOR FOR 
		SELECT 	
			CD_EMP,
			CD_FILIAL,			
			CD_FORN,
			RZ_FORN,
			CD_CNT,
			NR_CHQ,
			SERIE_CHQ,
			ANO_CHQ,
			ROUND(SUM(VL_PGTO - (VLR_DESP_OUTR + VL_IMP + VLR_DEVOLUCAO)),2) AS VLR_EMIT_DEST,
			ROUND(SUM(VL_DESC), 2) 			AS VL_DESC,
			HIST,
			ROUND(SUM(VL_IMP), 2) 			AS VL_IMP,
			ROUND(SUM(VLR_DESP_OUTR), 2) 	AS VLR_DESP_OUTR,
			ROUND(SUM(VLR_DEVOLUCAO),2)  	AS VLR_DEVOLUCAO,
			NR_TIT,
			NR_NF,
			DT_PAG,
			CD_BC_LANC,
			NR_DP,
			CD_PG_DEB_LOTE,
			TIPO_PAGTO,
			CD_BC,
			DS_BC,
			DS_CNT,
			MOSTRA_DS_CNT,
			NR_CNT_EDI
		FROM ##RS_RETURN 
		GROUP BY 
			CD_EMP,
			CD_FILIAL,			
			CD_FORN,
			RZ_FORN,
			CD_CNT,
			NR_CHQ,
			SERIE_CHQ,
			ANO_CHQ,
			HIST,							
			NR_TIT,
			NR_NF,
			DT_PAG,
			CD_BC_LANC,
			NR_DP,
			CD_PG_DEB_LOTE,
			TIPO_PAGTO,
			CD_BC,
			DS_BC,
			DS_CNT,
			MOSTRA_DS_CNT,
			NR_CNT_EDI
		ORDER BY
			CD_BC_LANC
		
		--Abrindo cursor
		OPEN RS_RESULT
		
		--Atribuindo valores do select nas variveis
		FETCH NEXT FROM RS_RESULT INTO 
			@RS_CD_EMP,
			@RS_CD_FILIAL,
			@RS_CD_FORN,
			@RS_RZ_FORN,
			@RS_CD_CNT,
			@RS_NR_CHQ,
			@RS_SERIE_CHQ,
			@RS_ANO_CHQ,
			@RS_VLR_EMIT_DEST,
			@RS_VL_DESC,
			@RS_HIST,
			@RS_VL_IMP,
			@RS_VLR_DESP_OUTR,
			@RS_VLR_DEVOLUCAO,
			@RS_NR_TIT,
			@RS_NR_NF,
			@RS_DT_PAG,
			@RS_CD_BC_LANC,
			@RS_NR_DP,
			@RS_CD_PG_DEB_LOTE,
			@RS_TIPO_PAGTO,
			@RS_CD_BC,
			@RS_DS_BC,
			@RET_DS_CNT,
			@RS_MOSTRA_DS_CNT,
			@RET_NR_CNT_EDI

		--Iniciando lao
		WHILE @@FETCH_STATUS = 0
			BEGIN	 		
					
				SET @CODIGO_INTERNO = CONVERT(VARCHAR, @RS_CD_BC_LANC) + ' - ' + CONVERT(VARCHAR, @RS_CD_FILIAL)

				--Buscando credito do pagamento
				if @RS_CD_BC_LANC > 0
					begin
						IF @RS_CD_BC_LANC <> @RS_CD_BC_LANC_ANT 
							begin
								

								SET @RS_CD_BC_LANC_ANT=@RS_CD_BC_LANC
								--print 'EXEC 19-1 P_EXP_CTB_MOV_PG_CRED_BANCARIO'+CONVERT(VARCHAR, GETDATE(), 108);
								EXEC P_EXP_CTB_MOV_PG_CRED_BANCARIO @CD_EMP,@CD_FILIAL,@DT_INI,@DT_FIM,@RS_CD_BC_LANC, @CODIGO_INTERNO
								--print 'EXEC 19-2 P_EXP_CTB_MOV_PG_CRED_BANCARIO_JUROS'+CONVERT(VARCHAR, GETDATE(), 108);
								EXEC P_EXP_CTB_MOV_PG_CRED_BANCARIO_JUROS @CD_EMP,@CD_FILIAL,@DT_INI,@DT_FIM,@RS_CD_BC_LANC, @CODIGO_INTERNO
							end
					end

				SELECT 							
					@RET_CD_CTB_CNT					= CD_CTB_CNT,
					@RET_CD_CTB_CNT_RED				= CD_CTB_CNT_RED
				FROM UFD_BUSCA_CONTA_PG_FORN(@CD_EMP, @RS_CD_FORN)
				
				------------------------------------------------------------------------------------------------------------------
				--PAGAMENTO FORNECEDOR - DEBITO 
				------------------------------------------------------------------------------------------------------------------				
				SET @HIST = 'REF: ' + @RS_HIST + ' CONTA: '+ CASE WHEN @RS_MOSTRA_DS_CNT = 1 THEN ' ' + ISNULL(@RET_DS_CNT, '') ELSE ISNULL(@RET_NR_CNT_EDI,'') END + ' ' + ISNULL(@RS_CD_BC,'') + '-' + ISNULL(@RS_DS_BC,'');
				
				IF @RS_NR_CHQ > 0   
					BEGIN
						SET @HIST = @HIST + ' FORNECEDOR: ' + @RS_RZ_FORN 
					END

					IF @RS_TIPO_PAGTO = 'LOTE'  
						  BEGIN 
							 SET	@NUM_DUPL  =  @RS_CD_PG_DEB_LOTE
							 SET @NR_DOCUMENTO = @RS_NR_TIT   
						  END
					 ELSE
					   BEGIN
						  SET @NUMERODUPL =  RIGHT('0000'+ CAST(@RS_CD_FILIAL AS VARCHAR(4)),4) + CAST(@RS_NR_DP AS VARCHAR ) 
						  SET @NUM_DUPL  =  @NUMERODUPL
					   END

						  IF @RS_NR_CHQ > 0 
						  	BEGIN
								SET   @NR_DOCUMENTO =  @RS_CD_BC_LANC
								SET   @NUM_DUPL  =  @RS_CD_BC_LANC	
							END

						  ELSE

							 BEGIN
								 SET   @NR_DOCUMENTO =  @RS_NR_TIT
							 END									
				
				
				SET @HIST = REPLACE (@HIST,'	',' ')

				INSERT INTO ##CTB_EXP_MOV  

							 (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
							 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
							 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
							 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC, COD_INTERNO_DOMINIO, CD_BC)

					SELECT		@RS_CD_EMP									AS CD_EMP,
								@CD_FILIAL									AS CD_FILIAL_EXPORT,
								@RS_CD_FILIAL									AS CD_FILIAL,
								16											AS CD_MOVIMENTO,
								'PAGAMENTO FORNECEDOR'							AS MOVIMENTO,
								''												AS OPERACAO,
								'PAGTO DUPL. - DEBITO'							AS OPERACAO_DEBITO,
								0												AS CD_CNT_RED_CREDITO,
								''												AS CD_CNT_CREDITO,																
								@RET_CD_CTB_CNT_RED								AS CD_CNT_RED_DEBITO,
								@RET_CD_CTB_CNT									AS CD_CNT_DEBITO,
								@RS_DT_PAG										AS DT_MOV,
								@HIST 				                        	AS HIST,								
								@RS_VLR_EMIT_DEST								AS VLR_LANC,
								'D'												AS TP_TRANSA,
								0 												AS RATEIO_CENTRO_CUSTO,
								'' 												AS DS_CENTRO_CUSTO,
								0 												AS CNT_CENTRO_CUSTO,
								0 												AS VLR_CENTRO_CUSTO,
								'FORNECEDOR'									AS ORIG_CONTA,
								@RS_CD_FORN 									AS COD_CONTA,
								OBJECT_NAME(@@PROCID)							AS NM_PROCEDURE
								, 'V' AS TIPO_LANCTO
								, 0 AS CD_EVENTO
								, @NUM_DUPL AS NR_DP								
								, 0  AS ANO
								, @NR_DOCUMENTO AS NR_DOC
								, @RS_CD_BC_LANC AS CD_BC_LANC
								, @CODIGO_INTERNO
								, @RS_CD_BC AS CD_BC;

										
				------------------------------------------------------------------------------------------------------------------
				--DESCONTOS FORNECEDOR - DEBITO 
				------------------------------------------------------------------------------------------------------------------
				IF @RS_VL_DESC > 0 
					BEGIN
						IF @RS_NR_CHQ > 0    
							BEGIN
								SET @HIST = 'DESCONTOS OBTIDOS - REF: ' + @RS_HIST + ' FORNECEDOR: ' + @RS_RZ_FORN
							END	
						ELSE
							BEGIN
								SET @HIST = 'DESCONTOS OBTIDOS - REF: ' + @RS_HIST 
							END
										
					SET @HIST = REPLACE (@HIST,'	',' ')
						INSERT INTO ##CTB_EXP_MOV 
						
								    (CD_EMP, CD_FILIAL_EXPORT,CD_FILIAL , CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								    CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								    VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								    ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC, COD_INTERNO_DOMINIO, CD_BC) 

							SELECT		@RS_CD_EMP										AS CD_EMP,
										@CD_FILIAL										AS CD_FILIAL_EXPORT,
										@RS_CD_FILIAL									AS CD_FILIAL,
										16												AS CD_MOVIMENTO,
										'PAGAMENTO FORNECEDOR'							AS MOVIMENTO,
										'DESCONTOS OBTIDOS - CREDITO'					AS OPERACAO,
										''												AS OPERACAO_DEBITO,
										0												AS CD_CNT_RED_CREDITO,
										''					                            AS CD_CNT_CREDITO,																
										0												AS CD_CNT_RED_DEBITO,
										''												AS CD_CNT_DEBITO,
										@RS_DT_PAG										AS DT_MOV,
										@HIST 											AS HIST,								
										@RS_VL_DESC										AS VLR_LANC,
										'C'												AS TP_TRANSA,
										0 												AS RATEIO_CENTRO_CUSTO,
										'' 												AS DS_CENTRO_CUSTO,
										0 												AS CNT_CENTRO_CUSTO,
										0 												AS VLR_CENTRO_CUSTO,
										'FILIAIS'										AS ORIG_CONTA,
										17 												AS COD_CONTA,
										OBJECT_NAME(@@PROCID)							AS NM_PROCEDURE
									   , 'V' AS TIPO_LANCTO
									   , 0 AS CD_EVENTO
									   , @NUM_DUPL AS NR_DP	
									   , 0  AS ANO
									   , @NR_DOCUMENTO AS NR_DOC
								        , @RS_CD_BC_LANC AS CD_BC_LANC
										, @CODIGO_INTERNO
										, @RS_CD_BC AS CD_BC;
					
					END
				
			
				IF @RS_VLR_DEVOLUCAO > 0 
					BEGIN					
						------------------------------------------------------------------------------------------------------------------
						--ABATIMENTO DEVOLUCAO FORNECEDOR - DEBITO 
						------------------------------------------------------------------------------------------------------------------	
						IF @RS_NR_CHQ > 0    
							BEGIN
								SET @HIST = 'VLR. DE ABATIMENTO S/ DEVOLUCAO DE MERCADORIAS - REF: ' + @RS_HIST + ' FORNECEDOR: ' + @RS_RZ_FORN
							END	
						ELSE
							BEGIN
								SET @HIST = 'VLR. DE ABATIMENTO S/ DEVOLUCAO DE MERCADORIAS - REF: ' + @RS_HIST 
							END
						                       				
						SET @HIST = REPLACE (@HIST,'	',' ')
						INSERT INTO ##CTB_EXP_MOV 
						
								(CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC, COD_INTERNO_DOMINIO, CD_BC) 

							SELECT		@RS_CD_EMP										AS CD_EMP,
										@CD_FILIAL										AS CD_FILIAL_EXPORT,
										@RS_CD_FILIAL									AS CD_FILIAL,
										16												AS CD_MOVIMENTO,
										'PAGAMENTO FORNECEDOR'							AS MOVIMENTO,
										''												AS OPERACAO,
										'PAGTO DUPL. - DEBITO'					        AS OPERACAO_DEBITO,
										0												AS CD_CNT_RED_CREDITO,
										''												AS CD_CNT_CREDITO,																
										@RET_CD_CTB_CNT_RED								AS CD_CNT_RED_DEBITO,
										@RET_CD_CTB_CNT									AS CD_CNT_DEBITO,
										@RS_DT_PAG										AS DT_MOV,
										@HIST 											AS HIST,								
										@RS_VLR_DEVOLUCAO								AS VLR_LANC,
										'D'												AS TP_TRANSA,
										0 												AS RATEIO_CENTRO_CUSTO,
										'' 												AS DS_CENTRO_CUSTO,
										0 												AS CNT_CENTRO_CUSTO,
										0 												AS VLR_CENTRO_CUSTO,
										'FORNECEDOR'									AS ORIG_CONTA,
										@RS_CD_FORN 									AS COD_CONTA,
										OBJECT_NAME(@@PROCID)							AS NM_PROCEDURE
									   , 'V' AS TIPO_LANCTO
									   , 0 AS CD_EVENTO
									   , @NUM_DUPL AS NR_DP	
									   , 0  AS ANO
									   , @NR_DOCUMENTO AS NR_DOC
									   , @RS_CD_BC_LANC AS CD_BC_LANC
									   , @CODIGO_INTERNO
									   , @RS_CD_BC AS CD_BC;
					
						
						------------------------------------------------------------------------------------------------------------------
						--ABATIMENTO DEVOLUCAO FORNECEDOR - CREDITO -  Ctb_Cnt_Devolucao_Compras
						------------------------------------------------------------------------------------------------------------------
						INSERT INTO ##CTB_EXP_MOV  

								(CD_EMP, CD_FILIAL_EXPORT, CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC, COD_INTERNO_DOMINIO, CD_BC)

							SELECT		@RS_CD_EMP										AS CD_EMP,
										@CD_FILIAL										AS CD_FILIAL_EXPORT,
										@RS_CD_FILIAL									AS CD_FILIAL,
										16												AS CD_MOVIMENTO,
										'PAGAMENTO FORNECEDOR'							AS MOVIMENTO,
										'PAGTO DUPL. - DEBITO'				            AS OPERACAO,
										''												AS OPERACAO_DEBITO,
										0												AS CD_CNT_RED_CREDITO,
										''												AS CD_CNT_CREDITO,																
										0												AS CD_CNT_RED_DEBITO,
										''												AS CD_CNT_DEBITO,
										@RS_DT_PAG										AS DT_MOV,
										@HIST 											AS HIST,								
										@RS_VLR_DEVOLUCAO								AS VLR_LANC,
										'C'												AS TP_TRANSA,
										0 												AS RATEIO_CENTRO_CUSTO,
										'' 												AS DS_CENTRO_CUSTO,
										0 												AS CNT_CENTRO_CUSTO,
										0 												AS VLR_CENTRO_CUSTO,
										'FILIAIS'										AS ORIG_CONTA,
										28 												AS COD_CONTA,
										OBJECT_NAME(@@PROCID)							AS NM_PROCEDURE																						
										  , 'V' AS TIPO_LANCTO
										  , 0 AS CD_EVENTO
										  , @NUM_DUPL AS NR_DP	
										  , 0  AS ANO
										  , @NR_DOCUMENTO AS NR_DOC
										  , @RS_CD_BC_LANC AS CD_BC_LANC
										  , @CODIGO_INTERNO
										  , @RS_CD_BC AS CD_BC;
					
					
					END
					
				
				IF @RS_VLR_DESP_OUTR > 0 
					BEGIN						
						------------------------------------------------------------------------------------------------------------------
						--DESPESAS BANCARIAS - DEBITO -  Ctb_Cnt_Taxas_Contas_Pagar
						------------------------------------------------------------------------------------------------------------------
						
						IF @RS_NR_CHQ > 0    
							BEGIN
								SET @HIST = 'DESPESAS BANCARIAS - REF: ' + @RS_HIST + ' FORNECEDOR: ' + @RS_RZ_FORN
							END	
						ELSE
							BEGIN
								SET @HIST = 'DESPESAS BANCARIAS - REF: ' + @RS_HIST 
							END
						SET @HIST = REPLACE (@HIST,'	',' ')
						INSERT INTO ##CTB_EXP_MOV 
						
								(CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC, COD_INTERNO_DOMINIO, CD_BC)
						 
							SELECT		@RS_CD_EMP										AS CD_EMP,
										@CD_FILIAL										AS CD_FILIAL_EXPORT,
										@RS_CD_FILIAL									AS CD_FILIAL,
										16												AS CD_MOVIMENTO,
										'PAGAMENTO FORNECEDOR'							AS MOVIMENTO,
										''												AS OPERACAO,
										'PAGTO DUPL. - DEBITO'							AS OPERACAO_DEBITO,
										0												AS CD_CNT_RED_CREDITO,
										''												AS CD_CNT_CREDITO,																
										0												AS CD_CNT_RED_DEBITO,
										''												AS CD_CNT_DEBITO,
										@RS_DT_PAG										AS DT_MOV,
										@HIST 											AS HIST,								
										@RS_VLR_DESP_OUTR								AS VLR_LANC,
										'D'												AS TP_TRANSA,
										0 												AS RATEIO_CENTRO_CUSTO,
										'' 												AS DS_CENTRO_CUSTO,
										0 												AS CNT_CENTRO_CUSTO,
										0 												AS VLR_CENTRO_CUSTO,
										'FILIAIS'										AS ORIG_CONTA,
										27 												AS COD_CONTA,
										OBJECT_NAME(@@PROCID)							AS NM_PROCEDURE																
										  , 'V' AS TIPO_LANCTO
										  , 0 AS CD_EVENTO
										  , @NUM_DUPL AS NR_DP	
										  , 0  AS ANO
										  , @NR_DOCUMENTO AS NR_DOC
										  , @RS_CD_BC_LANC AS CD_BC_LANC
										  , @CODIGO_INTERNO
										  , @RS_CD_BC AS CD_BC;
					
					END
					
					
				------------------------------------------------------------------------------------------------------------------
				--Prximo registro				
				------------------------------------------------------------------------------------------------------------------
				--Atribuindo valores do select nas variveis
				FETCH NEXT FROM RS_RESULT INTO 
					@RS_CD_EMP,
					@RS_CD_FILIAL,
					@RS_CD_FORN,
					@RS_RZ_FORN,
					@RS_CD_CNT,
					@RS_NR_CHQ,
					@RS_SERIE_CHQ,
					@RS_ANO_CHQ,
					@RS_VLR_EMIT_DEST,
					@RS_VL_DESC,
					@RS_HIST,
					@RS_VL_IMP,
					@RS_VLR_DESP_OUTR,
					@RS_VLR_DEVOLUCAO,
					@RS_NR_TIT,
					@RS_NR_NF,
					@RS_DT_PAG,
					@RS_CD_BC_LANC	,
					@RS_NR_DP	,
					@RS_CD_PG_DEB_LOTE,	
					@RS_TIPO_PAGTO,
					@RS_CD_BC,
					@RS_DS_BC,
					@RET_DS_CNT,
					@RS_MOSTRA_DS_CNT,
					@RET_NR_CNT_EDI
			END

			--Buscando credito do pagamento
			if @RS_CD_BC_LANC <> 0
				begin
					IF @RS_CD_BC_LANC <> @RS_CD_BC_LANC_ANT 
						begin
							SET @RS_CD_BC_LANC_ANT=@RS_CD_BC_LANC
							PRINT 'EXEC P_EXP_CTB_MOV_PG_CRED_BANCARIO '+CONVERT(VARCHAR, GETDATE(), 108)
							EXEC P_EXP_CTB_MOV_PG_CRED_BANCARIO @CD_EMP,@CD_FILIAL,@DT_INI,@DT_FIM,@RS_CD_BC_LANC, @CODIGO_INTERNO
							PRINT 'EXEC P_EXP_CTB_MOV_PG_CRED_BANCARIO '+CONVERT(VARCHAR, GETDATE(), 108)
							EXEC P_EXP_CTB_MOV_PG_CRED_BANCARIO_JUROS @CD_EMP,@CD_FILIAL,@DT_INI,@DT_FIM,@RS_CD_BC_LANC, @CODIGO_INTERNO
						end
				end
					
	CLOSE RS_RESULT
	DEALLOCATE RS_RESULT
	DROP TABLE ##RS_RETURN	

END

END TRY
BEGIN CATCH
	DROP TABLE ##RS_RETURN
	CLOSE RS_RESULT
	DEALLOCATE RS_RESULT	

    DECLARE @ErrorMessage VARCHAR(4000)=ERROR_MESSAGE();  
    DECLARE @ErrorSeverity INT=ERROR_SEVERITY();  
    DECLARE @ErrorState INT=ERROR_STATE();  


    INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro )
    SELECT ERROR_NUMBER() AS numero,
       @ErrorSeverity AS severidade,
       @ErrorState AS estado,
       ERROR_PROCEDURE() AS rotina,
       ERROR_LINE() AS linha,
       @ErrorMessage AS mensagem,
       GETDATE() AS dtErro;
    
    RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);

END CATCH					
  

 